<?php
/**
*Ȩ ţcms
*ٷַ www.niubicms.com
*汾 2014-10-31 16:52
**/
class ask
{
	private $db;
	private $question_table;
	private $answer_table;
	private $type_table;

	function __construct()
	{
		global $db;
		$this->db=$db;
		$this->question_table=LA_PRE.'ask_question';
		$this->type_table=LA_PRE.'ask_type';
		$this->answer_table=LA_PRE.'ask_answer';
	}
	
	function questionlist($userid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$userid?' AND userid='.$userid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND title LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->question_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function questionstatis($moduleid=20,$status=-1)
	{
		global $siteidobj,$_siteid;
		$moduleid=intval($moduleid);
		$status=intval($status);

		$where=$_siteid?' siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$moduleid?' AND moduleid='.$moduleid:'';

		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->question_table` WHERE $where");
	}

	function formatquestionurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-question-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$modinfo=$moduleobj->get(20);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],20);
			
			if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= $modsettings['domain'].'question-'.intval($id).'.html';
				}
				else
				{
					$url= $modsettings['domain'].'index.php?mod='.$modinfo['folder'].'&action=question&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			else
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= LA_PATH.$modinfo['folder'].'/question-'.intval($id).'.html';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/index.php?mod='.$modinfo['folder'].'&action=question&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}

	function formatqtypeurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-qlist-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$modinfo=$moduleobj->get(20);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],20);
			
			if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= $modsettings['domain'].'list-'.intval($id).'.html';
				}
				else
				{
					$url= $modsettings['domain'].'index.php?mod='.$modinfo['folder'].'&action=list&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			else
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= LA_PATH.$modinfo['folder'].'/list-'.intval($id).'.html';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/index.php?mod='.$modinfo['folder'].'&action=list&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}

	
	function getquestion($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->question_table` WHERE `$this->question_table`.`id`=$id");
	}

	function questionset($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getquestion($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->question_table,$info,'id='.$id);
				}
			}
		}
		return true;
	}

	function question_delete($ids=array(),$userid)
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getquestion($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->mysql_delete($this->question_table,$id);
				}
			}
		}
		return true;
	}

	function admin_question_add($info)
	{
		$info['userid']=0;
		$info['inputtime']=TIME;
		$info['ip']=IP;
		$info['status']=1;
		$info['siteid']=intval($_SESSION['siteid']);
		return $this->db->insert($this->question_table,$info,true);
	}

	function askquestion($info)
	{
		$info['siteid']=intval($_SESSION['siteid']);
		$info=la_htmlspecialchars($info);
		return $this->db->insert($this->question_table,$info);
	}

	function admin_question_edit($info,$id)
	{
		return $this->db->update($this->question_table,$info,'id='.intval($id));
	}

		
	function typelist($typeid=0)
	{
		global $page,$_siteid,$siteidobj;
		$moduleid=intval($moduleid);
		$typeid=intval($typeid);

		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;
		$where.=$typeid?' AND parentid='.$typeid:' AND parentid=0';


		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id ASC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=25;
		$result=$datalist->getlist($this->type_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}



	function type_add($info)
	{
		$info['parentid']?$this->typeparentid($info['parentid']):0;
		$info['siteid']=intval($_SESSION['siteid']);

		$names=array_map('trim',explode("|",$info['name']));
		foreach($names as $name)
		{
			if($name)
			{
				$info['name']=strip_tags($name);
				$this->db->insert($this->type_table,$info);
			}
		}
		return true;
	}

	function type_delete($id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->typeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$this->db->mysql_delete($this->type_table,intval($id),'typeid');
		$this->db->mysql_delete($this->type_table,intval($id),'id');
		return true;
	}

	function gettypeid($moduleid=7)
	{
		$r=$this->db->fetch_one("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." ORDER BY `$this->type_table`.`id` ASC");
		return $r?$r['id']:0;
	}

	function type_edit($info,$id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->typeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		$info['parentid']?$this->typeparentid($info['parentid']):0;
		return $this->db->update($this->type_table,$info,'id='.intval($id));
	}

	function typeinfo($id)
	{
		return $this->db->fetch_one("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`id`=".intval($id));
	}

	function typename($id)
	{
		$r=$this->typeinfo($id);
		return $r['name'];
	}

	function parenttypename($id)
	{
		$pid=$this->typeparentid($id);
		$r=$pid?$this->typeinfo($pid):array('name'=>'');
		return $r['name'];
	}

	function typeparentid($id)
	{
		$r=$this->typeinfo($id);
		return $r['parentid'];
	}

	function type_select($parentid=0,$g=3)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE  `$this->type_table`.`parentid`=".intval($parentid)." ORDER BY `$this->type_table`.`id` ASC");
		foreach($r as $_r)
		{
			if($g>=2)
			{
				$r2=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE  `$this->type_table`.`parentid`=".intval($_r['id'])." ORDER BY `$this->type_table`.`id` ASC");
				if($r2)
				{
					$str.='<optgroup label="'.$_r['name'].'">';
					foreach($r2 as $_r2)
					{
						if($g>=3)
						{
							$r3=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`parentid`=".intval($_r2['id'])." ORDER BY `$this->type_table`.`id` ASC");
							if($r3)
							{
								$str.='<option value="'.$_r2['id'].'" disabled="disabled">'.$_r2['name'].'</option>';
								foreach($r3 as $_r3)
								{
									$str.='<option value="'.$_r3['id'].'">|--'.$_r3['name'].'</option>';
								}
							}
							else
							{
								$str.='<option value="'.$_r2['id'].'">'.$_r2['name'].'</option>';
							}
						}
						else
						{
							$str.='<option value="'.$_r2['id'].'">'.$_r2['name'].'</option>';
						}
					}
					$str.='</optgroup>';
				}
				else
				{
					$str.='<option value="'.$_r['id'].'">'.$_r['name'].'</option>';
				}
			}
			else
			{
				$str.='<option value="'.$_r['id'].'">'.$_r['name'].'</option>';
			}
		}

		return $str;
	}

	function type_select_cat($parentid=0)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`parentid`=".intval($parentid)." ORDER BY `$this->type_table`.`id` ASC");
		foreach($r as $_r)
		{
			$r2=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`parentid`=".intval($_r['id'])." ORDER BY `$this->type_table`.`id` ASC");
			if($r2)
			{
				$str.='<option value="'.$_r['id'].'">'.$_r['name'].'</option>';
				foreach($r2 as $_r2)
				{
					$str.='<option value="'.$_r2['id'].'">|--'.$_r2['name'].'</option>';
				}
				$str.='</option>';
			}
			else
			{
				$str.='<option value="'.$_r['id'].'">'.$_r['name'].'</option>';
			}
		}

		return $str;
	}

	function answerlist($qid=0,$starttime='',$endtime='',$k='',$uid=0)
	{
		global $page,$_siteid,$siteidobj;
		$uid=intval($uid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$qid?' AND qid='.$qid:'';
		$where.=$uid?' AND uid='.$uid:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND content LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->answer_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function answerstatis($qid=0)
	{
		global $siteidobj,$_siteid;
		$qid=intval($qid);

		$where=$_siteid?' siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$qid?' AND qid='.$qid:'';

		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->answer_table` WHERE $where");
	}

	function answerset($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getanswer($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->answer_table,$info,'id='.$id);
				}
			}
		}
		return true;
	}
	
	
	function getanswer($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->answer_table` WHERE `$this->answer_table`.`id`=$id");
	}

	function set_answer($id)
	{
		$id=intval($id);
		$ainfo=$this->getanswer($id);
		return $this->db->update($this->question_table,array('aid'=>$id),'id='.$ainfo['qid']);
	}

	function askanswer($info)
	{
		$info=la_htmlspecialchars($info);
		return $this->db->insert($this->answer_table,$info);
	}

	function question_settop($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;
		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);

		$tiao=$settings['top_type']==0?$_point:$_amount;
		if($settings['top_fee']<=$tiao)
		{
			if($settings['top_type']==0)
			{
				$memberobj->set($userid,array('point'=>max(0,$_point-$settings['top_fee'])));
			}
			else
			{
				$memberobj->set($userid,array('amount'=>max(0,$_amount-$settings['top_fee'])));
			}
			return $this->db->query("UPDATE `$this->question_table` SET `$this->question_table`.`istop`='".(TIME+24*3600)."' WHERE `$this->question_table`.`id`=$id AND  `$this->question_table`.`userid`=$userid");
		}
		
		return false;
	}

	function question_setdelete($id,$userid)
	{
		$id=intval($id);
		$userid=intval($userid);
		return $this->db->query("DELETE FROM `$this->question_table` WHERE `$this->question_table`.`id`=$id AND  `$this->question_table`.`userid`=$userid");
	}

	function question_refresh($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;

		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);
		
		$tiao=$settings['pay_type']==0?$_point:$_amount;
		if($settings['pay_fee']<=$tiao)
		{
			if($settings['pay_type']==0)
			{
				$memberobj->set($userid,array('point'=>max(0,$_point-$settings['pay_fee'])));
			}
			else
			{
				$memberobj->set($userid,array('amount'=>max(0,$_amount-$settings['pay_fee'])));
			}

			$this->db->query("UPDATE `$this->question_table` SET `$this->question_table`.`inputtime`=".TIME." WHERE `$this->question_table`.`id`=$id AND  `$this->question_table`.`userid`=$userid");
			return true;
		}
		return false;
	}

	function answer_delete($ids=array(),$userid)
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getanswer($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->mysql_delete($this->answer_table,$id);
				}
			}
		}
		return true;
	}

}
?>